/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.coderbot.iris.Iris;
import net.coderbot.iris.UpdateInfo;
import net.coderbot.iris.config.IrisConfig;
import net.coderbot.iris.gl.shader.StandardMacros;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jetbrains.annotations.Nullable;

public class UpdateChecker {
    private final Version currentVersion;
    private CompletableFuture<UpdateInfo> info;
    private boolean shouldShowUpdateMessage;
    private boolean usedIrisInstaller;

    public UpdateChecker(Version version) {
        this.currentVersion = version;
        if (Objects.equals(System.getProperty("iris.installer", "false"), "true")) {
            this.usedIrisInstaller = true;
        }
    }

    public void checkForUpdates(IrisConfig irisConfig) {
        if (irisConfig.shouldDisableUpdateMessage()) {
            this.shouldShowUpdateMessage = false;
            return;
        }
        this.info = CompletableFuture.supplyAsync(() -> {
            try {
                Object object;
                File file = FabricLoader.getInstance().getGameDir().resolve("irisUpdateInfo.json").toFile();
                if (DateUtils.isSameDay((Date)new Date(), (Date)new Date(file.lastModified()))) {
                    Iris.logger.warn("[Iris Update Check] Cached update file detected, using that!");
                    try {
                        object = (UpdateInfo)new Gson().fromJson(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8), UpdateInfo.class);
                    }
                    catch (JsonSyntaxException | NullPointerException throwable) {
                        Iris.logger.error("[Iris Update Check] Cached file invalid, will delete!", throwable);
                        Files.delete(file.toPath());
                        return null;
                    }
                    try {
                        if (this.currentVersion.compareTo((Object)SemanticVersion.parse((String)((UpdateInfo)object).semanticVersion)) >= 0) return null;
                        this.shouldShowUpdateMessage = true;
                        Iris.logger.warn("[Iris Update Check] New update detected, showing update message!");
                        return object;
                    }
                    catch (VersionParsingException versionParsingException) {
                        Iris.logger.error("[Iris Update Check] Caught a VersionParsingException while parsing semantic versions!", versionParsingException);
                    }
                }
                object = new URL("https://github.com/IrisShaders/Iris-Update-Index/releases/latest/download/updateIndex.json").openStream();
                try {
                    String string;
                    try {
                        string = new JsonParser().parse((Reader)new InputStreamReader((InputStream)object)).getAsJsonObject().get(StandardMacros.getMcVersion()).getAsString();
                    }
                    catch (NullPointerException nullPointerException) {
                        Iris.logger.warn("[Iris Update Check] This version doesn't have an update index, skipping.");
                        UpdateInfo updateInfo = null;
                        if (object == null) return updateInfo;
                        ((InputStream)object).close();
                        return updateInfo;
                    }
                    String string2 = IOUtils.toString((URL)new URL(string), (Charset)StandardCharsets.UTF_8);
                    UpdateInfo updateInfo = (UpdateInfo)new Gson().fromJson(string2, UpdateInfo.class);
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                    bufferedWriter.write(string2);
                    bufferedWriter.close();
                    try {
                        if (this.currentVersion.compareTo((Object)SemanticVersion.parse((String)updateInfo.semanticVersion)) < 0) {
                            this.shouldShowUpdateMessage = true;
                            Iris.logger.info("[Iris Update Check] New update detected, showing update message!");
                            UpdateInfo updateInfo2 = updateInfo;
                            return updateInfo2;
                        }
                        UpdateInfo updateInfo3 = null;
                        return updateInfo3;
                    }
                    catch (VersionParsingException versionParsingException) {
                        Iris.logger.error("[Iris Update Check] Caught a VersionParsingException while parsing semantic versions!", versionParsingException);
                        return null;
                    }
                }
                finally {
                    if (object != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Iris.logger.warn("[Iris Update Check] Unable to download " + fileNotFoundException.getMessage());
                return null;
            }
            catch (IOException iOException) {
                Iris.logger.warn("[Iris Update Check] Failed to get update info!", iOException);
            }
            return null;
        });
    }

    @Nullable
    public UpdateInfo getUpdateInfo() {
        if (this.info != null && this.info.isDone()) {
            try {
                return this.info.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    public Optional<class_2561> getUpdateMessage() {
        if (this.shouldShowUpdateMessage) {
            UpdateInfo updateInfo = this.getUpdateInfo();
            if (updateInfo == null) {
                return Optional.empty();
            }
            String string = class_310.method_1551().field_1690.field_1883.toLowerCase(Locale.ROOT);
            String string2 = updateInfo.updateInfo.containsKey(string) ? updateInfo.updateInfo.get(string) : updateInfo.updateInfo.get("en_us");
            String[] stringArray = string2.split("\\{link}");
            if (stringArray.length > 1) {
                class_2585 class_25852 = new class_2585(stringArray[0]);
                class_2585 class_25853 = new class_2585(stringArray[1]);
                class_5250 class_52502 = new class_2585(this.usedIrisInstaller ? "the Iris Installer" : updateInfo.modHost).method_27694(class_25832 -> class_25832.method_10958(new class_2558(class_2558.class_2559.field_11749, this.usedIrisInstaller ? updateInfo.installer : updateInfo.modDownload)).method_30938(Boolean.valueOf(true)));
                return Optional.of(class_25852.method_10852((class_2561)class_52502).method_10852((class_2561)class_25853));
            }
            class_5250 class_52503 = new class_2585(this.usedIrisInstaller ? "the Iris Installer" : updateInfo.modHost).method_27694(class_25832 -> class_25832.method_10958(new class_2558(class_2558.class_2559.field_11749, this.usedIrisInstaller ? updateInfo.installer : updateInfo.modDownload)).method_30938(Boolean.valueOf(true)));
            return Optional.of(new class_2585(stringArray[0]).method_10852((class_2561)class_52503));
        }
        return Optional.empty();
    }

    public Optional<String> getUpdateLink() {
        if (this.shouldShowUpdateMessage) {
            UpdateInfo updateInfo = this.getUpdateInfo();
            return Optional.of(this.usedIrisInstaller ? updateInfo.installer : updateInfo.modDownload);
        }
        return Optional.empty();
    }
}

